/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.OneArgFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;
import org.squiddev.cobalt.function.ThreeArgFunction;
import org.squiddev.cobalt.function.TwoArgFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.function.ZeroArgFunction;
import org.squiddev.cobalt.unwind.SuspendedTask;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class LibFunction
extends LuaFunction {
    @Nullable String name;

    LibFunction() {
    }

    @Override
    public String debugName() {
        return this.name != null ? this.name : super.toString();
    }

    protected abstract LuaValue call(LuaState var1) throws LuaError, UnwindThrowable;

    protected abstract LuaValue call(LuaState var1, LuaValue var2) throws LuaError, UnwindThrowable;

    protected abstract LuaValue call(LuaState var1, LuaValue var2, LuaValue var3) throws LuaError, UnwindThrowable;

    protected abstract LuaValue call(LuaState var1, LuaValue var2, LuaValue var3, LuaValue var4) throws LuaError, UnwindThrowable;

    protected abstract Varargs invoke(LuaState var1, Varargs var2) throws LuaError, UnwindThrowable;

    public static void setGlobalLibrary(LuaState state, String name, LuaValue library) throws LuaError {
        state.globals().rawset(name, library);
        state.registry().getSubTable(Constants.LOADED).rawset(name, library);
    }

    public static LibFunction create(ZeroArg fn) {
        return new ZeroArgFunction(fn);
    }

    public static LibFunction create(OneArg fn) {
        return new OneArgFunction(fn);
    }

    public static LibFunction create(TwoArg fn) {
        return new TwoArgFunction(fn);
    }

    public static LibFunction create(ThreeArg fn) {
        return new ThreeArgFunction(fn);
    }

    public static LibFunction createV(final ManyArgs fn) {
        return new VarArgFunction(){

            @Override
            protected Varargs invoke(LuaState state, Varargs args) throws LuaError {
                return fn.invoke(state, args);
            }
        };
    }

    public static LibFunction createS(final Suspended fn) {
        return new ResumableVarArgFunction<SuspendedTask<Varargs>>(){

            @Override
            protected Varargs invoke(LuaState state, DebugFrame frame, Varargs args) throws LuaError, UnwindThrowable {
                return fn.invoke(state, DebugState.get(state).getStackUnsafe(), args);
            }

            @Override
            public Varargs resume(LuaState state, SuspendedTask<Varargs> object, Varargs value) throws LuaError, UnwindThrowable {
                return object.resume(value);
            }
        };
    }

    public static interface ZeroArg {
        public LuaValue call(LuaState var1) throws LuaError;
    }

    public static interface OneArg {
        public LuaValue call(LuaState var1, LuaValue var2) throws LuaError;
    }

    public static interface TwoArg {
        public LuaValue call(LuaState var1, LuaValue var2, LuaValue var3) throws LuaError;
    }

    public static interface ThreeArg {
        public LuaValue call(LuaState var1, LuaValue var2, LuaValue var3, LuaValue var4) throws LuaError;
    }

    public static interface ManyArgs {
        public Varargs invoke(LuaState var1, Varargs var2) throws LuaError;
    }

    public static interface Suspended {
        public Varargs invoke(LuaState var1, DebugFrame var2, Varargs var3) throws LuaError, UnwindThrowable;
    }
}

